/*==============================================================================
DEPOSIT BETA VS UNINSURED SHARE PLOT
==============================================================================
Purpose:
This script generates a binned scatter plot showing the relationship between
deposit beta and the average uninsured share of domestic deposits for banks
in the sample. 

Input:
- $path_clean/analysis_ready_data.dta (Prepared bank-quarter panel dataset)
- Global variable: $fig_deposit_beta (output filename)

Output:
- $path_figures/${fig_deposit_beta}.pdf

Paper Correspondence:
- Main Analysis: Figure 7

Last updated: July 03, 2025
==============================================================================*/
display "--- Starting Deposit Beta vs Uninsured Share Plot ---"

**===============================================================================
* Step 1: Generate Binned Scatter Plot
*===============================================================================
* Purpose: Create the binned scatter plot using the prepared variables.

* Generate the binned scatter plot
* Plot beta_depexp (deposit beta in Feb 2023) against the average uninsured share (computed in 2a)
* Filter data to include only the Feb 2023 period
binscatter beta_depexp uninsuredsh_domdep_avg if period == "feb2023", ///
   n(18) /* Number of bins */ ///
   ylabel(,grid angle(0) tlcolor(black) tposition(outside)) /* Y-axis label formatting */ ///
   title("Feb 2023") /* Plot title */ ///
   ytitle("Deposit beta") /* Y-axis title */ ///
   xtitle("Uninsured share") /* X-axis title */ ///
   xlabel(, format(%03.2f) tlcolor(black) tposition(crossing)) /* X-axis label formatting */ ///
   mcolors(red) lcolors(black) /* Marker and line colors */ ///
   plotregion(lcolor(black))  /* Plot region border color */ ///
   scheme(s1color) /* Plot scheme */ ///

**===============================================================================
* Step 2: Export Figure
*===============================================================================
* Export the plot to PDF using the global filename variable
graph export "$path_figures/${fig_deposit_beta}.pdf", as(pdf) fontface(Georgia) replace

display "--- Deposit Beta vs Uninsured Share Plot completed ---"
display "--- Output saved as: ${fig_deposit_beta}.pdf ---"
